@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupReplicaResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of Arc Sql availability group replica resource
 * @property configure null
 * @property replicaName the replica name.
 */
public data class SqlAvailabilityGroupReplicaResourcePropertiesArgs(
    public val configure: Output<AvailabilityGroupConfigureArgs>? = null,
    public val replicaName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupReplicaResourcePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupReplicaResourcePropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlAvailabilityGroupReplicaResourcePropertiesArgs.builder()
            .configure(configure?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicaName(replicaName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlAvailabilityGroupReplicaResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SqlAvailabilityGroupReplicaResourcePropertiesArgsBuilder internal constructor() {
    private var configure: Output<AvailabilityGroupConfigureArgs>? = null

    private var replicaName: Output<String>? = null

    /**
     * @param value null
     */
    @JvmName("nribbnrdyofbyjlx")
    public suspend fun configure(`value`: Output<AvailabilityGroupConfigureArgs>) {
        this.configure = value
    }

    /**
     * @param value the replica name.
     */
    @JvmName("vspvufmnxovtrooe")
    public suspend fun replicaName(`value`: Output<String>) {
        this.replicaName = value
    }

    /**
     * @param value null
     */
    @JvmName("sfwsarcrsgyybryw")
    public suspend fun configure(`value`: AvailabilityGroupConfigureArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configure = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("gjhqrelnqvfimvuy")
    public suspend fun configure(argument: suspend AvailabilityGroupConfigureArgsBuilder.() -> Unit) {
        val toBeMapped = AvailabilityGroupConfigureArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configure = mapped
    }

    /**
     * @param value the replica name.
     */
    @JvmName("htitmeyhajmsbfpn")
    public suspend fun replicaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaName = mapped
    }

    internal fun build(): SqlAvailabilityGroupReplicaResourcePropertiesArgs =
        SqlAvailabilityGroupReplicaResourcePropertiesArgs(
            configure = configure,
            replicaName = replicaName,
        )
}
