@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sRawArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The raw kubernetes information.
 * @property spec The kubernetes spec information.
 */
public data class SqlManagedInstanceK8sRawArgs(
    public val spec: Output<SqlManagedInstanceK8sSpecArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sRawArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sRawArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sRawArgs.builder()
            .spec(spec?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SqlManagedInstanceK8sRawArgs].
 */
@PulumiTagMarker
public class SqlManagedInstanceK8sRawArgsBuilder internal constructor() {
    private var spec: Output<SqlManagedInstanceK8sSpecArgs>? = null

    /**
     * @param value The kubernetes spec information.
     */
    @JvmName("qjoxwoqjepjugvhl")
    public suspend fun spec(`value`: Output<SqlManagedInstanceK8sSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value The kubernetes spec information.
     */
    @JvmName("tpffiqdkktunncbi")
    public suspend fun spec(`value`: SqlManagedInstanceK8sSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument The kubernetes spec information.
     */
    @JvmName("mmykbcfbmwiwdije")
    public suspend fun spec(argument: suspend SqlManagedInstanceK8sSpecArgsBuilder.() -> Unit) {
        val toBeMapped = SqlManagedInstanceK8sSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    internal fun build(): SqlManagedInstanceK8sRawArgs = SqlManagedInstanceK8sRawArgs(
        spec = spec,
    )
}
