@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The kubernetes spec information.
 * @property replicas This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
 * @property scheduling The kubernetes scheduling information.
 * @property security The kubernetes security information.
 * @property settings The kubernetes settings information.
 */
public data class SqlManagedInstanceK8sSpecArgs(
    public val replicas: Output<Int>? = null,
    public val scheduling: Output<K8sSchedulingArgs>? = null,
    public val security: Output<K8sSecurityArgs>? = null,
    public val settings: Output<K8sSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sSpecArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceK8sSpecArgs.builder()
            .replicas(replicas?.applyValue({ args0 -> args0 }))
            .scheduling(scheduling?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .security(security?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SqlManagedInstanceK8sSpecArgs].
 */
@PulumiTagMarker
public class SqlManagedInstanceK8sSpecArgsBuilder internal constructor() {
    private var replicas: Output<Int>? = null

    private var scheduling: Output<K8sSchedulingArgs>? = null

    private var security: Output<K8sSecurityArgs>? = null

    private var settings: Output<K8sSettingsArgs>? = null

    /**
     * @param value This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
     */
    @JvmName("ccqvwwbrxwtnspie")
    public suspend fun replicas(`value`: Output<Int>) {
        this.replicas = value
    }

    /**
     * @param value The kubernetes scheduling information.
     */
    @JvmName("luejkyxoldqmfgnp")
    public suspend fun scheduling(`value`: Output<K8sSchedulingArgs>) {
        this.scheduling = value
    }

    /**
     * @param value The kubernetes security information.
     */
    @JvmName("oiwlhgyuwqkjtlon")
    public suspend fun security(`value`: Output<K8sSecurityArgs>) {
        this.security = value
    }

    /**
     * @param value The kubernetes settings information.
     */
    @JvmName("klxmdnciggmgmhuo")
    public suspend fun settings(`value`: Output<K8sSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
     */
    @JvmName("fmpyadnohvafthlg")
    public suspend fun replicas(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicas = mapped
    }

    /**
     * @param value The kubernetes scheduling information.
     */
    @JvmName("jykqhoowrvqevvfo")
    public suspend fun scheduling(`value`: K8sSchedulingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduling = mapped
    }

    /**
     * @param argument The kubernetes scheduling information.
     */
    @JvmName("ygcxkpwcvfnevkmt")
    public suspend fun scheduling(argument: suspend K8sSchedulingArgsBuilder.() -> Unit) {
        val toBeMapped = K8sSchedulingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduling = mapped
    }

    /**
     * @param value The kubernetes security information.
     */
    @JvmName("spuyoyucdbbbhrnj")
    public suspend fun security(`value`: K8sSecurityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.security = mapped
    }

    /**
     * @param argument The kubernetes security information.
     */
    @JvmName("fvegovsihejmyetf")
    public suspend fun security(argument: suspend K8sSecurityArgsBuilder.() -> Unit) {
        val toBeMapped = K8sSecurityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.security = mapped
    }

    /**
     * @param value The kubernetes settings information.
     */
    @JvmName("mfsiifgucthahxvm")
    public suspend fun settings(`value`: K8sSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument The kubernetes settings information.
     */
    @JvmName("vlkfxdurntcicsnc")
    public suspend fun settings(argument: suspend K8sSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = K8sSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    internal fun build(): SqlManagedInstanceK8sSpecArgs = SqlManagedInstanceK8sSpecArgs(
        replicas = replicas,
        scheduling = scheduling,
        security = security,
        settings = settings,
    )
}
