@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlServerInstancePropertiesArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.ArcSqlServerLicenseType
import com.pulumi.azurenative.azurearcdata.kotlin.enums.ConnectionStatus
import com.pulumi.azurenative.azurearcdata.kotlin.enums.DefenderStatus
import com.pulumi.azurenative.azurearcdata.kotlin.enums.EditionType
import com.pulumi.azurenative.azurearcdata.kotlin.enums.HostType
import com.pulumi.azurenative.azurearcdata.kotlin.enums.SqlVersion
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of SqlServerInstance.
 * @property azureDefenderStatus Status of Azure Defender.
 * @property azureDefenderStatusLastUpdated Timestamp of last Azure Defender status update.
 * @property collation SQL Server collation.
 * @property containerResourceId ARM Resource id of the container resource (Azure Arc for Servers).
 * @property cores The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
 * @property currentVersion SQL Server current version.
 * @property edition SQL Server edition.
 * @property hostType Type of host for Azure Arc SQL Server
 * @property instanceName SQL Server instance name.
 * @property licenseType SQL Server license type.
 * @property patchLevel SQL Server update level.
 * @property productId SQL Server product ID.
 * @property status The cloud connectivity status.
 * @property tcpDynamicPorts Dynamic TCP ports used by SQL Server.
 * @property tcpStaticPorts Static TCP ports used by SQL Server.
 * @property vCore The number of logical processors used by the SQL Server instance.
 * @property version SQL Server version.
 */
public data class SqlServerInstancePropertiesArgs(
    public val azureDefenderStatus: Output<Either<String, DefenderStatus>>? = null,
    public val azureDefenderStatusLastUpdated: Output<String>? = null,
    public val collation: Output<String>? = null,
    public val containerResourceId: Output<String>,
    public val cores: Output<String>? = null,
    public val currentVersion: Output<String>? = null,
    public val edition: Output<Either<String, EditionType>>? = null,
    public val hostType: Output<Either<String, HostType>>? = null,
    public val instanceName: Output<String>? = null,
    public val licenseType: Output<Either<String, ArcSqlServerLicenseType>>? = null,
    public val patchLevel: Output<String>? = null,
    public val productId: Output<String>? = null,
    public val status: Output<Either<String, ConnectionStatus>>,
    public val tcpDynamicPorts: Output<String>? = null,
    public val tcpStaticPorts: Output<String>? = null,
    public val vCore: Output<String>? = null,
    public val version: Output<Either<String, SqlVersion>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlServerInstancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.SqlServerInstancePropertiesArgs = com.pulumi.azurenative.azurearcdata.inputs.SqlServerInstancePropertiesArgs.builder()
        .azureDefenderStatus(
            azureDefenderStatus?.applyValue({ args0 ->
                args0.transform(
                    { args0 -> args0 },
                    { args0 -> args0.let({ args0 -> args0.toJava() }) },
                )
            }),
        )
        .azureDefenderStatusLastUpdated(azureDefenderStatusLastUpdated?.applyValue({ args0 -> args0 }))
        .collation(collation?.applyValue({ args0 -> args0 }))
        .containerResourceId(containerResourceId.applyValue({ args0 -> args0 }))
        .cores(cores?.applyValue({ args0 -> args0 }))
        .currentVersion(currentVersion?.applyValue({ args0 -> args0 }))
        .edition(
            edition?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .hostType(
            hostType?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .instanceName(instanceName?.applyValue({ args0 -> args0 }))
        .licenseType(
            licenseType?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .patchLevel(patchLevel?.applyValue({ args0 -> args0 }))
        .productId(productId?.applyValue({ args0 -> args0 }))
        .status(
            status.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .tcpDynamicPorts(tcpDynamicPorts?.applyValue({ args0 -> args0 }))
        .tcpStaticPorts(tcpStaticPorts?.applyValue({ args0 -> args0 }))
        .vCore(vCore?.applyValue({ args0 -> args0 }))
        .version(
            version?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        ).build()
}

/**
 * Builder for [SqlServerInstancePropertiesArgs].
 */
@PulumiTagMarker
public class SqlServerInstancePropertiesArgsBuilder internal constructor() {
    private var azureDefenderStatus: Output<Either<String, DefenderStatus>>? = null

    private var azureDefenderStatusLastUpdated: Output<String>? = null

    private var collation: Output<String>? = null

    private var containerResourceId: Output<String>? = null

    private var cores: Output<String>? = null

    private var currentVersion: Output<String>? = null

    private var edition: Output<Either<String, EditionType>>? = null

    private var hostType: Output<Either<String, HostType>>? = null

    private var instanceName: Output<String>? = null

    private var licenseType: Output<Either<String, ArcSqlServerLicenseType>>? = null

    private var patchLevel: Output<String>? = null

    private var productId: Output<String>? = null

    private var status: Output<Either<String, ConnectionStatus>>? = null

    private var tcpDynamicPorts: Output<String>? = null

    private var tcpStaticPorts: Output<String>? = null

    private var vCore: Output<String>? = null

    private var version: Output<Either<String, SqlVersion>>? = null

    /**
     * @param value Status of Azure Defender.
     */
    @JvmName("tvguokwarrynnklb")
    public suspend fun azureDefenderStatus(`value`: Output<Either<String, DefenderStatus>>) {
        this.azureDefenderStatus = value
    }

    /**
     * @param value Timestamp of last Azure Defender status update.
     */
    @JvmName("yufjbwuhwtotgltb")
    public suspend fun azureDefenderStatusLastUpdated(`value`: Output<String>) {
        this.azureDefenderStatusLastUpdated = value
    }

    /**
     * @param value SQL Server collation.
     */
    @JvmName("pxomcfhatjkojxgc")
    public suspend fun collation(`value`: Output<String>) {
        this.collation = value
    }

    /**
     * @param value ARM Resource id of the container resource (Azure Arc for Servers).
     */
    @JvmName("racsxbepnfdqabyi")
    public suspend fun containerResourceId(`value`: Output<String>) {
        this.containerResourceId = value
    }

    /**
     * @param value The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
     */
    @JvmName("tvdutwlfohxqpiks")
    public suspend fun cores(`value`: Output<String>) {
        this.cores = value
    }

    /**
     * @param value SQL Server current version.
     */
    @JvmName("ihbosehcygpviawp")
    public suspend fun currentVersion(`value`: Output<String>) {
        this.currentVersion = value
    }

    /**
     * @param value SQL Server edition.
     */
    @JvmName("qishcesbshjmitya")
    public suspend fun edition(`value`: Output<Either<String, EditionType>>) {
        this.edition = value
    }

    /**
     * @param value Type of host for Azure Arc SQL Server
     */
    @JvmName("qrujgtqwkbjrsofi")
    public suspend fun hostType(`value`: Output<Either<String, HostType>>) {
        this.hostType = value
    }

    /**
     * @param value SQL Server instance name.
     */
    @JvmName("slykhfuywcwgmbgg")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("nhdtedklqvuihbgc")
    public suspend fun licenseType(`value`: Output<Either<String, ArcSqlServerLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value SQL Server update level.
     */
    @JvmName("xvqblxgfiaiuifge")
    public suspend fun patchLevel(`value`: Output<String>) {
        this.patchLevel = value
    }

    /**
     * @param value SQL Server product ID.
     */
    @JvmName("lcpeasriarscerqp")
    public suspend fun productId(`value`: Output<String>) {
        this.productId = value
    }

    /**
     * @param value The cloud connectivity status.
     */
    @JvmName("dkghalvxowwxaump")
    public suspend fun status(`value`: Output<Either<String, ConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value Dynamic TCP ports used by SQL Server.
     */
    @JvmName("ejglkrvhwfbuiktk")
    public suspend fun tcpDynamicPorts(`value`: Output<String>) {
        this.tcpDynamicPorts = value
    }

    /**
     * @param value Static TCP ports used by SQL Server.
     */
    @JvmName("ttqdreufwxyhcksk")
    public suspend fun tcpStaticPorts(`value`: Output<String>) {
        this.tcpStaticPorts = value
    }

    /**
     * @param value The number of logical processors used by the SQL Server instance.
     */
    @JvmName("vdbwvdlxubucdpyf")
    public suspend fun vCore(`value`: Output<String>) {
        this.vCore = value
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("bfcaprbbmtsnekij")
    public suspend fun version(`value`: Output<Either<String, SqlVersion>>) {
        this.version = value
    }

    /**
     * @param value Status of Azure Defender.
     */
    @JvmName("fupvwoehoscrbvhx")
    public suspend fun azureDefenderStatus(`value`: Either<String, DefenderStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureDefenderStatus = mapped
    }

    /**
     * @param value Status of Azure Defender.
     */
    @JvmName("fbpqctupeuoowwkp")
    public fun azureDefenderStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DefenderStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureDefenderStatus = mapped
    }

    /**
     * @param value Status of Azure Defender.
     */
    @JvmName("ijukgwelonypinyq")
    public fun azureDefenderStatus(`value`: DefenderStatus) {
        val toBeMapped = Either.ofRight<String, DefenderStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureDefenderStatus = mapped
    }

    /**
     * @param value Timestamp of last Azure Defender status update.
     */
    @JvmName("tktvslaitdicdusr")
    public suspend fun azureDefenderStatusLastUpdated(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureDefenderStatusLastUpdated = mapped
    }

    /**
     * @param value SQL Server collation.
     */
    @JvmName("nccnihcecenkwqfj")
    public suspend fun collation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.collation = mapped
    }

    /**
     * @param value ARM Resource id of the container resource (Azure Arc for Servers).
     */
    @JvmName("eshxcmujjjeeweee")
    public suspend fun containerResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerResourceId = mapped
    }

    /**
     * @param value The number of total cores of the Operating System Environment (OSE) hosting the SQL Server instance.
     */
    @JvmName("rboiwruljvdksors")
    public suspend fun cores(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cores = mapped
    }

    /**
     * @param value SQL Server current version.
     */
    @JvmName("dnftaehffjxlywtd")
    public suspend fun currentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentVersion = mapped
    }

    /**
     * @param value SQL Server edition.
     */
    @JvmName("jksjoelsranphbmt")
    public suspend fun edition(`value`: Either<String, EditionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value SQL Server edition.
     */
    @JvmName("sqlraglruqvyfowo")
    public fun edition(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EditionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value SQL Server edition.
     */
    @JvmName("rmbynnesuwmptclv")
    public fun edition(`value`: EditionType) {
        val toBeMapped = Either.ofRight<String, EditionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Type of host for Azure Arc SQL Server
     */
    @JvmName("ffpyasbjndlsylby")
    public suspend fun hostType(`value`: Either<String, HostType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value Type of host for Azure Arc SQL Server
     */
    @JvmName("lcalysboajqifwht")
    public fun hostType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HostType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value Type of host for Azure Arc SQL Server
     */
    @JvmName("avvbugkctjddhrug")
    public fun hostType(`value`: HostType) {
        val toBeMapped = Either.ofRight<String, HostType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hostType = mapped
    }

    /**
     * @param value SQL Server instance name.
     */
    @JvmName("vtebcewhafvilldy")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("afrbmuupkjsrxnej")
    public suspend fun licenseType(`value`: Either<String, ArcSqlServerLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("afnmxahblmaxldhn")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ArcSqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("agcisvohhflccaey")
    public fun licenseType(`value`: ArcSqlServerLicenseType) {
        val toBeMapped = Either.ofRight<String, ArcSqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value SQL Server update level.
     */
    @JvmName("uomftsqystlbkajt")
    public suspend fun patchLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patchLevel = mapped
    }

    /**
     * @param value SQL Server product ID.
     */
    @JvmName("rqwironmkbwshbod")
    public suspend fun productId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productId = mapped
    }

    /**
     * @param value The cloud connectivity status.
     */
    @JvmName("mgbfwpqmvaencsga")
    public suspend fun status(`value`: Either<String, ConnectionStatus>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The cloud connectivity status.
     */
    @JvmName("calcmjqnopeqyqis")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The cloud connectivity status.
     */
    @JvmName("mgxtisyxwsatptys")
    public fun status(`value`: ConnectionStatus) {
        val toBeMapped = Either.ofRight<String, ConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Dynamic TCP ports used by SQL Server.
     */
    @JvmName("usqlnajikotltxol")
    public suspend fun tcpDynamicPorts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpDynamicPorts = mapped
    }

    /**
     * @param value Static TCP ports used by SQL Server.
     */
    @JvmName("xfcnqgwvovhrnjag")
    public suspend fun tcpStaticPorts(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcpStaticPorts = mapped
    }

    /**
     * @param value The number of logical processors used by the SQL Server instance.
     */
    @JvmName("bujuooojtmremlub")
    public suspend fun vCore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCore = mapped
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("ecnajutxksfxwajq")
    public suspend fun version(`value`: Either<String, SqlVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("enrjffegqnnnrdue")
    public fun version(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value SQL Server version.
     */
    @JvmName("vvluvepemtunkrrd")
    public fun version(`value`: SqlVersion) {
        val toBeMapped = Either.ofRight<String, SqlVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SqlServerInstancePropertiesArgs = SqlServerInstancePropertiesArgs(
        azureDefenderStatus = azureDefenderStatus,
        azureDefenderStatusLastUpdated = azureDefenderStatusLastUpdated,
        collation = collation,
        containerResourceId = containerResourceId ?: throw PulumiNullFieldException("containerResourceId"),
        cores = cores,
        currentVersion = currentVersion,
        edition = edition,
        hostType = hostType,
        instanceName = instanceName,
        licenseType = licenseType,
        patchLevel = patchLevel,
        productId = productId,
        status = status ?: throw PulumiNullFieldException("status"),
        tcpDynamicPorts = tcpDynamicPorts,
        tcpStaticPorts = tcpStaticPorts,
        vCore = vCore,
        version = version,
    )
}
