@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * DNS server details
 * @property domainName DNS domain name for which DNS lookups should be forwarded to the Active Directory DNS servers.
 * @property nameserverIPAddresses List of Active Directory DNS server IP addresses.
 * @property preferK8sDnsForPtrLookups Flag indicating whether to prefer Kubernetes DNS server response over AD DNS server response for IP address lookups.
 * @property replicas Replica count for DNS proxy service. Default value is 1.
 */
public data class ActiveDirectoryConnectorDNSDetailsResponse(
    public val domainName: String? = null,
    public val nameserverIPAddresses: List<String>,
    public val preferK8sDnsForPtrLookups: Boolean? = null,
    public val replicas: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.ActiveDirectoryConnectorDNSDetailsResponse): ActiveDirectoryConnectorDNSDetailsResponse = ActiveDirectoryConnectorDNSDetailsResponse(
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            nameserverIPAddresses = javaType.nameserverIPAddresses().map({ args0 -> args0 }),
            preferK8sDnsForPtrLookups = javaType.preferK8sDnsForPtrLookups().map({ args0 ->
                args0
            }).orElse(null),
            replicas = javaType.replicas().map({ args0 -> args0 }).orElse(null),
        )
    }
}
