@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of an Active Directory connector resource
 * @property domainServiceAccountLoginInformation Username and password for domain service account authentication.
 * @property provisioningState The provisioning state of the Active Directory connector resource.
 * @property spec null
 * @property status null
 */
public data class ActiveDirectoryConnectorPropertiesResponse(
    public val domainServiceAccountLoginInformation: BasicLoginInformationResponse? = null,
    public val provisioningState: String,
    public val spec: ActiveDirectoryConnectorSpecResponse,
    public val status: ActiveDirectoryConnectorStatusResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.ActiveDirectoryConnectorPropertiesResponse): ActiveDirectoryConnectorPropertiesResponse = ActiveDirectoryConnectorPropertiesResponse(
            domainServiceAccountLoginInformation = javaType.domainServiceAccountLoginInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.BasicLoginInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            spec = javaType.spec().let({ args0 ->
                com.pulumi.azurenative.azurearcdata.kotlin.outputs.ActiveDirectoryConnectorSpecResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.ActiveDirectoryConnectorStatusResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
