@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The status of the Kubernetes custom resource.
 * @property lastUpdateTime The time that the custom resource was last updated.
 * @property observedGeneration The version of the replicaSet associated with the AD connector custom resource.
 * @property state The state of the AD connector custom resource.
 */
public data class ActiveDirectoryConnectorStatusResponse(
    public val lastUpdateTime: String? = null,
    public val observedGeneration: Double? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.ActiveDirectoryConnectorStatusResponse): ActiveDirectoryConnectorStatusResponse = ActiveDirectoryConnectorStatusResponse(
            lastUpdateTime = javaType.lastUpdateTime().map({ args0 -> args0 }).orElse(null),
            observedGeneration = javaType.observedGeneration().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
