@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Details about the Active Directory domain controllers associated with this AD connector instance
 * @property primaryDomainController Information about the Primary Domain Controller (PDC) in the AD domain.
 * @property secondaryDomainControllers null
 */
public data class ActiveDirectoryDomainControllersResponse(
    public val primaryDomainController: ActiveDirectoryDomainControllerResponse? = null,
    public val secondaryDomainControllers: List<ActiveDirectoryDomainControllerResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.ActiveDirectoryDomainControllersResponse): ActiveDirectoryDomainControllersResponse = ActiveDirectoryDomainControllersResponse(
            primaryDomainController = javaType.primaryDomainController().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.ActiveDirectoryDomainControllerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            secondaryDomainControllers = javaType.secondaryDomainControllers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.ActiveDirectoryDomainControllerResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
