@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The data controller properties.
 * @property basicLoginInformation Deprecated. Azure Arc Data Services data controller no longer expose any endpoint. All traffic are exposed through Kubernetes native API.
 * @property clusterId If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
 * @property extensionId If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
 * @property infrastructure The infrastructure the data controller is running on.
 * @property k8sRaw The raw kubernetes information
 * @property lastUploadedDate Last uploaded date from Kubernetes cluster. Defaults to current date time
 * @property logAnalyticsWorkspaceConfig Log analytics workspace id and primary key
 * @property logsDashboardCredential Login credential for logs dashboard on the Kubernetes cluster.
 * @property metricsDashboardCredential Login credential for metrics dashboard on the Kubernetes cluster.
 * @property onPremiseProperty Properties from the Kubernetes data controller
 * @property provisioningState The provisioning state of the Arc Data Controller resource.
 * @property uploadServicePrincipal Deprecated. Service principal is deprecated in favor of Arc Kubernetes service extension managed identity.
 * @property uploadWatermark Properties on upload watermark.  Mostly timestamp for each upload data type
 */
public data class DataControllerPropertiesResponse(
    public val basicLoginInformation: BasicLoginInformationResponse? = null,
    public val clusterId: String? = null,
    public val extensionId: String? = null,
    public val infrastructure: String? = null,
    public val k8sRaw: Any? = null,
    public val lastUploadedDate: String? = null,
    public val logAnalyticsWorkspaceConfig: LogAnalyticsWorkspaceConfigResponse? = null,
    public val logsDashboardCredential: BasicLoginInformationResponse? = null,
    public val metricsDashboardCredential: BasicLoginInformationResponse? = null,
    public val onPremiseProperty: OnPremisePropertyResponse? = null,
    public val provisioningState: String,
    public val uploadServicePrincipal: UploadServicePrincipalResponse? = null,
    public val uploadWatermark: UploadWatermarkResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.DataControllerPropertiesResponse): DataControllerPropertiesResponse = DataControllerPropertiesResponse(
            basicLoginInformation = javaType.basicLoginInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.BasicLoginInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterId = javaType.clusterId().map({ args0 -> args0 }).orElse(null),
            extensionId = javaType.extensionId().map({ args0 -> args0 }).orElse(null),
            infrastructure = javaType.infrastructure().map({ args0 -> args0 }).orElse(null),
            k8sRaw = javaType.k8sRaw().map({ args0 -> args0 }).orElse(null),
            lastUploadedDate = javaType.lastUploadedDate().map({ args0 -> args0 }).orElse(null),
            logAnalyticsWorkspaceConfig = javaType.logAnalyticsWorkspaceConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.LogAnalyticsWorkspaceConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            logsDashboardCredential = javaType.logsDashboardCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.BasicLoginInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metricsDashboardCredential = javaType.metricsDashboardCredential().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.BasicLoginInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            onPremiseProperty = javaType.onPremiseProperty().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.OnPremisePropertyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            uploadServicePrincipal = javaType.uploadServicePrincipal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.UploadServicePrincipalResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uploadWatermark = javaType.uploadWatermark().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.UploadWatermarkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
