@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The properties of a failover group resource.
 * @property partnerManagedInstanceId The resource ID of the partner SQL managed instance.
 * @property provisioningState The provisioning state of the failover group resource.
 * @property spec The specifications of the failover group resource.
 * @property status The status of the failover group custom resource.
 */
public data class FailoverGroupPropertiesResponse(
    public val partnerManagedInstanceId: String,
    public val provisioningState: String,
    public val spec: FailoverGroupSpecResponse,
    public val status: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.FailoverGroupPropertiesResponse): FailoverGroupPropertiesResponse = FailoverGroupPropertiesResponse(
            partnerManagedInstanceId = javaType.partnerManagedInstanceId(),
            provisioningState = javaType.provisioningState(),
            spec = javaType.spec().let({ args0 ->
                com.pulumi.azurenative.azurearcdata.kotlin.outputs.FailoverGroupSpecResponse.Companion.toKotlin(args0)
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
