@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The specifications of the failover group resource.
 * @property partnerMI The name of the partner SQL managed instance.
 * @property partnerMirroringCert The mirroring endpoint public certificate for the partner SQL managed instance. Only PEM format is supported.
 * @property partnerMirroringURL The mirroring endpoint URL of the partner SQL managed instance.
 * @property partnerSyncMode The partner sync mode of the SQL managed instance.
 * @property role The role of the SQL managed instance in this failover group.
 * @property sharedName The shared name of the failover group for this SQL managed instance. Both SQL managed instance and its partner have to use the same shared name.
 * @property sourceMI The name of the SQL managed instance with this failover group role.
 */
public data class FailoverGroupSpecResponse(
    public val partnerMI: String? = null,
    public val partnerMirroringCert: String? = null,
    public val partnerMirroringURL: String? = null,
    public val partnerSyncMode: String? = null,
    public val role: String,
    public val sharedName: String? = null,
    public val sourceMI: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.FailoverGroupSpecResponse): FailoverGroupSpecResponse = FailoverGroupSpecResponse(
            partnerMI = javaType.partnerMI().map({ args0 -> args0 }).orElse(null),
            partnerMirroringCert = javaType.partnerMirroringCert().map({ args0 -> args0 }).orElse(null),
            partnerMirroringURL = javaType.partnerMirroringURL().map({ args0 -> args0 }).orElse(null),
            partnerSyncMode = javaType.partnerSyncMode().map({ args0 -> args0 }).orElse(null),
            role = javaType.role(),
            sharedName = javaType.sharedName().map({ args0 -> args0 }).orElse(null),
            sourceMI = javaType.sourceMI().map({ args0 -> args0 }).orElse(null),
        )
    }
}
