@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Transparent data encryption information.
 * @property mode Transparent data encryption mode. Can be Service Managed, Customer managed or disabled
 * @property protectorSecret Protector secret for customer managed Transparent data encryption mode
 */
public data class K8stransparentDataEncryptionResponse(
    public val mode: String? = null,
    public val protectorSecret: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.K8stransparentDataEncryptionResponse): K8stransparentDataEncryptionResponse = K8stransparentDataEncryptionResponse(
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            protectorSecret = javaType.protectorSecret().map({ args0 -> args0 }).orElse(null),
        )
    }
}
