@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Postgres Instance properties.
 * @property admin The instance admin
 * @property basicLoginInformation Username and password for basic authentication.
 * @property dataControllerId The data controller id
 * @property k8sRaw The raw kubernetes information
 * @property lastUploadedDate Last uploaded date from Kubernetes cluster. Defaults to current date time
 * @property provisioningState The provisioning state of the Azure Arc-enabled PostgreSQL instance.
 */
public data class PostgresInstancePropertiesResponse(
    public val admin: String? = null,
    public val basicLoginInformation: BasicLoginInformationResponse? = null,
    public val dataControllerId: String? = null,
    public val k8sRaw: Any? = null,
    public val lastUploadedDate: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.PostgresInstancePropertiesResponse): PostgresInstancePropertiesResponse = PostgresInstancePropertiesResponse(
            admin = javaType.admin().map({ args0 -> args0 }).orElse(null),
            basicLoginInformation = javaType.basicLoginInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.BasicLoginInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataControllerId = javaType.dataControllerId().map({ args0 -> args0 }).orElse(null),
            k8sRaw = javaType.k8sRaw().map({ args0 -> args0 }).orElse(null),
            lastUploadedDate = javaType.lastUploadedDate().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
