@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The resource model definition representing SKU for Azure Database for PostgresSQL - Azure Arc
 * @property capacity If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
 * @property dev Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here.
 * @property name The name of the SKU.  It is typically a letter+number code
 * @property size The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
 * @property tier This field is required to be implemented by the Resource Provider if the service has more than one tier.
 */
public data class PostgresInstanceSkuResponse(
    public val capacity: Int? = null,
    public val dev: Boolean? = null,
    public val family: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.PostgresInstanceSkuResponse): PostgresInstanceSkuResponse = PostgresInstanceSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            dev = javaType.dev().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
