@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The properties of Arc Sql availability group database replica resource
 * @property databaseName the database name.
 * @property databaseStateDescription Description of the database state of the availability replica.
 * @property isCommitParticipant Whether this replica is transaction committer.
 * @property isLocal Whether the availability database is local.
 * @property isPrimaryReplica Returns 1 if the replica is primary, or 0 if it is a secondary replica.
 * @property isSuspended Whether this data movement is suspended.
 * @property replicaName the database replica name.
 * @property suspendReasonDescription Description of the database suspended state reason.
 * @property synchronizationHealthDescription Description of the health of database.
 * @property synchronizationStateDescription Description of the data-movement state.
 */
public data class SqlAvailabilityGroupDatabaseReplicaResourcePropertiesResponse(
    public val databaseName: String? = null,
    public val databaseStateDescription: String,
    public val isCommitParticipant: Boolean,
    public val isLocal: Boolean,
    public val isPrimaryReplica: Boolean,
    public val isSuspended: Boolean,
    public val replicaName: String,
    public val suspendReasonDescription: String,
    public val synchronizationHealthDescription: String,
    public val synchronizationStateDescription: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlAvailabilityGroupDatabaseReplicaResourcePropertiesResponse): SqlAvailabilityGroupDatabaseReplicaResourcePropertiesResponse =
            SqlAvailabilityGroupDatabaseReplicaResourcePropertiesResponse(
                databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
                databaseStateDescription = javaType.databaseStateDescription(),
                isCommitParticipant = javaType.isCommitParticipant(),
                isLocal = javaType.isLocal(),
                isPrimaryReplica = javaType.isPrimaryReplica(),
                isSuspended = javaType.isSuspended(),
                replicaName = javaType.replicaName(),
                suspendReasonDescription = javaType.suspendReasonDescription(),
                synchronizationHealthDescription = javaType.synchronizationHealthDescription(),
                synchronizationStateDescription = javaType.synchronizationStateDescription(),
            )
    }
}
