@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of Arc Sql availability group replica resource
 * @property configure null
 * @property replicaId ID GUID of the availability group.
 * @property replicaName the replica name.
 * @property state null
 */
public data class SqlAvailabilityGroupReplicaResourcePropertiesResponse(
    public val configure: AvailabilityGroupConfigureResponse? = null,
    public val replicaId: String,
    public val replicaName: String? = null,
    public val state: AvailabilityGroupStateResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlAvailabilityGroupReplicaResourcePropertiesResponse): SqlAvailabilityGroupReplicaResourcePropertiesResponse =
            SqlAvailabilityGroupReplicaResourcePropertiesResponse(
                configure = javaType.configure().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurearcdata.kotlin.outputs.AvailabilityGroupConfigureResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                replicaId = javaType.replicaId(),
                replicaName = javaType.replicaName().map({ args0 -> args0 }).orElse(null),
                state = javaType.state().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.azurearcdata.kotlin.outputs.AvailabilityGroupStateResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
