@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * The kubernetes spec information.
 * @property replicas This option specifies the number of SQL Managed Instance replicas that will be deployed in your Kubernetes cluster for high availability purposes. If sku.tier is BusinessCritical, allowed values are '2' or '3' with default of '3'. If sku.tier is GeneralPurpose, replicas must be '1'.
 * @property scheduling The kubernetes scheduling information.
 * @property security The kubernetes security information.
 * @property settings The kubernetes settings information.
 */
public data class SqlManagedInstanceK8sSpecResponse(
    public val replicas: Int? = null,
    public val scheduling: K8sSchedulingResponse? = null,
    public val security: K8sSecurityResponse? = null,
    public val settings: K8sSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlManagedInstanceK8sSpecResponse): SqlManagedInstanceK8sSpecResponse = SqlManagedInstanceK8sSpecResponse(
            replicas = javaType.replicas().map({ args0 -> args0 }).orElse(null),
            scheduling = javaType.scheduling().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.K8sSchedulingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            security = javaType.security().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.K8sSecurityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.K8sSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
