@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of sqlManagedInstance.
 * @property admin The instance admin user
 * @property basicLoginInformation Username and password for basic authentication.
 * @property clusterId If a CustomLocation is provided, this contains the ARM id of the connected cluster the custom location belongs to.
 * @property dataControllerId null
 * @property endTime The instance end time
 * @property extensionId If a CustomLocation is provided, this contains the ARM id of the extension the custom location belongs to.
 * @property k8sRaw The raw kubernetes information
 * @property lastUploadedDate Last uploaded date from Kubernetes cluster. Defaults to current date time
 * @property licenseType The license type to apply for this managed instance.
 * @property provisioningState The provisioning state of the Arc-enabled SQL Managed Instance resource.
 * @property startTime The instance start time
 */
public data class SqlManagedInstancePropertiesResponse(
    public val admin: String? = null,
    public val basicLoginInformation: BasicLoginInformationResponse? = null,
    public val clusterId: String? = null,
    public val dataControllerId: String? = null,
    public val endTime: String? = null,
    public val extensionId: String? = null,
    public val k8sRaw: SqlManagedInstanceK8sRawResponse? = null,
    public val lastUploadedDate: String? = null,
    public val licenseType: String? = null,
    public val provisioningState: String,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlManagedInstancePropertiesResponse): SqlManagedInstancePropertiesResponse = SqlManagedInstancePropertiesResponse(
            admin = javaType.admin().map({ args0 -> args0 }).orElse(null),
            basicLoginInformation = javaType.basicLoginInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.BasicLoginInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterId = javaType.clusterId().map({ args0 -> args0 }).orElse(null),
            dataControllerId = javaType.dataControllerId().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            extensionId = javaType.extensionId().map({ args0 -> args0 }).orElse(null),
            k8sRaw = javaType.k8sRaw().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlManagedInstanceK8sRawResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            lastUploadedDate = javaType.lastUploadedDate().map({ args0 -> args0 }).orElse(null),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
