@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The properties of Arc Sql Server database resource
 * @property backupInformation
 * @property collationName Collation of the database.
 * @property compatibilityLevel Compatibility level of the database
 * @property databaseCreationDate Creation date of the database.
 * @property databaseOptions List of features that are enabled for the database
 * @property isReadOnly Whether the database is read only or not.
 * @property provisioningState The provisioning state of the Arc-enabled SQL Server database resource.
 * @property recoveryMode Status of the database.
 * @property sizeMB Size of the database.
 * @property spaceAvailableMB Space left of the database.
 * @property state State of the database.
 */
public data class SqlServerDatabaseResourcePropertiesResponse(
    public val backupInformation: SqlServerDatabaseResourcePropertiesResponseBackupInformation? =
        null,
    public val collationName: String? = null,
    public val compatibilityLevel: Int? = null,
    public val databaseCreationDate: String? = null,
    public val databaseOptions: SqlServerDatabaseResourcePropertiesResponseDatabaseOptions? = null,
    public val isReadOnly: Boolean? = null,
    public val provisioningState: String,
    public val recoveryMode: String? = null,
    public val sizeMB: Double? = null,
    public val spaceAvailableMB: Double? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlServerDatabaseResourcePropertiesResponse): SqlServerDatabaseResourcePropertiesResponse = SqlServerDatabaseResourcePropertiesResponse(
            backupInformation = javaType.backupInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerDatabaseResourcePropertiesResponseBackupInformation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            collationName = javaType.collationName().map({ args0 -> args0 }).orElse(null),
            compatibilityLevel = javaType.compatibilityLevel().map({ args0 -> args0 }).orElse(null),
            databaseCreationDate = javaType.databaseCreationDate().map({ args0 -> args0 }).orElse(null),
            databaseOptions = javaType.databaseOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.SqlServerDatabaseResourcePropertiesResponseDatabaseOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isReadOnly = javaType.isReadOnly().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            recoveryMode = javaType.recoveryMode().map({ args0 -> args0 }).orElse(null),
            sizeMB = javaType.sizeMB().map({ args0 -> args0 }).orElse(null),
            spaceAvailableMB = javaType.spaceAvailableMB().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
