@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The telemetry column for the SQL Server instance.
 * @property name The name of the telemetry column.
 * @property type The type of the telemetry column.
 */
public data class SqlServerInstanceTelemetryColumnResponse(
    public val name: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.SqlServerInstanceTelemetryColumnResponse): SqlServerInstanceTelemetryColumnResponse = SqlServerInstanceTelemetryColumnResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
