@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties on upload watermark.  Mostly timestamp for each upload data type
 * @property logs Last uploaded date for logs from kubernetes cluster. Defaults to current date time
 * @property metrics Last uploaded date for metrics from kubernetes cluster. Defaults to current date time
 * @property usages Last uploaded date for usages from kubernetes cluster. Defaults to current date time
 */
public data class UploadWatermarkResponse(
    public val logs: String? = null,
    public val metrics: String? = null,
    public val usages: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.UploadWatermarkResponse): UploadWatermarkResponse = UploadWatermarkResponse(
            logs = javaType.logs().map({ args0 -> args0 }).orElse(null),
            metrics = javaType.metrics().map({ args0 -> args0 }).orElse(null),
            usages = javaType.usages().map({ args0 -> args0 }).orElse(null),
        )
    }
}
