@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin

import com.pulumi.azurenative.azuredata.SqlServerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A SQL server.
 * Azure REST API version: 2019-07-24-preview. Prior API version in Azure Native 1.x: 2019-07-24-preview.
 * ## Example Usage
 * ### Creates or updates a SQL Server in a Registration group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServer = new AzureNative.AzureData.SqlServer("sqlServer", new()
 *     {
 *         Cores = 8,
 *         Edition = "Latin",
 *         PropertyBag = "",
 *         RegistrationID = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureData/SqlServerRegistrations/testsqlregistration",
 *         ResourceGroupName = "testrg",
 *         SqlServerName = "testsqlserver",
 *         SqlServerRegistrationName = "testsqlregistration",
 *         Version = "2008",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredata.NewSqlServer(ctx, "sqlServer", &azuredata.SqlServerArgs{
 * 			Cores:                     pulumi.Int(8),
 * 			Edition:                   pulumi.String("Latin"),
 * 			PropertyBag:               pulumi.String(""),
 * 			RegistrationID:            pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureData/SqlServerRegistrations/testsqlregistration"),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			SqlServerName:             pulumi.String("testsqlserver"),
 * 			SqlServerRegistrationName: pulumi.String("testsqlregistration"),
 * 			Version:                   pulumi.String("2008"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredata.SqlServer;
 * import com.pulumi.azurenative.azuredata.SqlServerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServer = new SqlServer("sqlServer", SqlServerArgs.builder()
 *             .cores(8)
 *             .edition("Latin")
 *             .propertyBag("")
 *             .registrationID("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureData/SqlServerRegistrations/testsqlregistration")
 *             .resourceGroupName("testrg")
 *             .sqlServerName("testsqlserver")
 *             .sqlServerRegistrationName("testsqlregistration")
 *             .version("2008")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredata:SqlServer testsqlserver /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}/sqlServers/{sqlServerName}
 * ```
 * @property cores Cores of the Sql Server.
 * @property edition Sql Server Edition.
 * @property propertyBag Sql Server Json Property Bag.
 * @property registrationID ID for Parent Sql Server Registration.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlServerName Name of the SQL Server.
 * @property sqlServerRegistrationName Name of the SQL Server registration.
 * @property version Version of the Sql Server.
 */
public data class SqlServerArgs(
    public val cores: Output<Int>? = null,
    public val edition: Output<String>? = null,
    public val propertyBag: Output<String>? = null,
    public val registrationID: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlServerName: Output<String>? = null,
    public val sqlServerRegistrationName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredata.SqlServerArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredata.SqlServerArgs =
        com.pulumi.azurenative.azuredata.SqlServerArgs.builder()
            .cores(cores?.applyValue({ args0 -> args0 }))
            .edition(edition?.applyValue({ args0 -> args0 }))
            .propertyBag(propertyBag?.applyValue({ args0 -> args0 }))
            .registrationID(registrationID?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlServerName(sqlServerName?.applyValue({ args0 -> args0 }))
            .sqlServerRegistrationName(sqlServerRegistrationName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlServerArgs].
 */
@PulumiTagMarker
public class SqlServerArgsBuilder internal constructor() {
    private var cores: Output<Int>? = null

    private var edition: Output<String>? = null

    private var propertyBag: Output<String>? = null

    private var registrationID: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlServerName: Output<String>? = null

    private var sqlServerRegistrationName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Cores of the Sql Server.
     */
    @JvmName("tshcvragkvcbswim")
    public suspend fun cores(`value`: Output<Int>) {
        this.cores = value
    }

    /**
     * @param value Sql Server Edition.
     */
    @JvmName("bleeptcdrumrkayu")
    public suspend fun edition(`value`: Output<String>) {
        this.edition = value
    }

    /**
     * @param value Sql Server Json Property Bag.
     */
    @JvmName("pmpaundnftrohymv")
    public suspend fun propertyBag(`value`: Output<String>) {
        this.propertyBag = value
    }

    /**
     * @param value ID for Parent Sql Server Registration.
     */
    @JvmName("jhivpittketnhege")
    public suspend fun registrationID(`value`: Output<String>) {
        this.registrationID = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("wptwsmaiaqignjqb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the SQL Server.
     */
    @JvmName("bsbudbeyivvyhoxt")
    public suspend fun sqlServerName(`value`: Output<String>) {
        this.sqlServerName = value
    }

    /**
     * @param value Name of the SQL Server registration.
     */
    @JvmName("ymxowpughiwncyqm")
    public suspend fun sqlServerRegistrationName(`value`: Output<String>) {
        this.sqlServerRegistrationName = value
    }

    /**
     * @param value Version of the Sql Server.
     */
    @JvmName("thvvnnltcadtolmo")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Cores of the Sql Server.
     */
    @JvmName("kcnxlphfnrxrcyuf")
    public suspend fun cores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cores = mapped
    }

    /**
     * @param value Sql Server Edition.
     */
    @JvmName("egwggerovywrxboc")
    public suspend fun edition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Sql Server Json Property Bag.
     */
    @JvmName("edcynxlkmxmrxvnr")
    public suspend fun propertyBag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyBag = mapped
    }

    /**
     * @param value ID for Parent Sql Server Registration.
     */
    @JvmName("lniyqftrbnaubvwc")
    public suspend fun registrationID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationID = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rwdbsoitjayotlmf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL Server.
     */
    @JvmName("xbcbywfkjgklrhgy")
    public suspend fun sqlServerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerName = mapped
    }

    /**
     * @param value Name of the SQL Server registration.
     */
    @JvmName("rxjyrqcsplwqkqdl")
    public suspend fun sqlServerRegistrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerRegistrationName = mapped
    }

    /**
     * @param value Version of the Sql Server.
     */
    @JvmName("qdgpumosojquddis")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): SqlServerArgs = SqlServerArgs(
        cores = cores,
        edition = edition,
        propertyBag = propertyBag,
        registrationID = registrationID,
        resourceGroupName = resourceGroupName,
        sqlServerName = sqlServerName,
        sqlServerRegistrationName = sqlServerRegistrationName,
        version = version,
    )
}
