@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin

import com.pulumi.azurenative.azuredata.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azuredata.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SqlServerRegistration].
 */
@PulumiTagMarker
public class SqlServerRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlServerRegistrationArgs = SqlServerRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlServerRegistrationArgsBuilder.() -> Unit) {
        val builder = SqlServerRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlServerRegistration {
        val builtJavaResource =
            com.pulumi.azurenative.azuredata.SqlServerRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlServerRegistration(builtJavaResource)
    }
}

/**
 * A SQL server registration.
 * Azure REST API version: 2019-07-24-preview. Prior API version in Azure Native 1.x: 2019-07-24-preview.
 * ## Example Usage
 * ### Creates or updates a SQL Server registration.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlServerRegistration = new AzureNative.AzureData.SqlServerRegistration("sqlServerRegistration", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlServerRegistrationName = "testsqlregistration",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredata.NewSqlServerRegistration(ctx, "sqlServerRegistration", &azuredata.SqlServerRegistrationArgs{
 * 			Location:                  pulumi.String("northeurope"),
 * 			ResourceGroupName:         pulumi.String("testrg"),
 * 			SqlServerRegistrationName: pulumi.String("testsqlregistration"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredata.SqlServerRegistration;
 * import com.pulumi.azurenative.azuredata.SqlServerRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlServerRegistration = new SqlServerRegistration("sqlServerRegistration", SqlServerRegistrationArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlServerRegistrationName("testsqlregistration")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredata:SqlServerRegistration testsqlregistration /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}
 * ```
 */
public class SqlServerRegistration internal constructor(
    override val javaResource: com.pulumi.azurenative.azuredata.SqlServerRegistration,
) : KotlinCustomResource(javaResource, SqlServerRegistrationMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Optional Properties as JSON string
     */
    public val propertyBag: Output<String>?
        get() = javaResource.propertyBag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource Group Name
     */
    public val resourceGroup: Output<String>?
        get() = javaResource.resourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Subscription Id
     */
    public val subscriptionId: Output<String>?
        get() = javaResource.subscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Read only system data
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlServerRegistrationMapper : ResourceMapper<SqlServerRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuredata.SqlServerRegistration::class == javaResource::class

    override fun map(javaResource: Resource): SqlServerRegistration =
        SqlServerRegistration(javaResource as com.pulumi.azurenative.azuredata.SqlServerRegistration)
}

/**
 * @see [SqlServerRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlServerRegistration].
 */
public suspend fun sqlServerRegistration(
    name: String,
    block: suspend SqlServerRegistrationResourceBuilder.() -> Unit,
): SqlServerRegistration {
    val builder = SqlServerRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlServerRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlServerRegistration(name: String): SqlServerRegistration {
    val builder = SqlServerRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
