@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin.inputs

import com.pulumi.azurenative.azuredata.inputs.GetSqlServerRegistrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlServerRegistrationName Name of the SQL Server registration.
 */
public data class GetSqlServerRegistrationPlainArgs(
    public val resourceGroupName: String,
    public val sqlServerRegistrationName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuredata.inputs.GetSqlServerRegistrationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredata.inputs.GetSqlServerRegistrationPlainArgs =
        com.pulumi.azurenative.azuredata.inputs.GetSqlServerRegistrationPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlServerRegistrationName(sqlServerRegistrationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlServerRegistrationPlainArgs].
 */
@PulumiTagMarker
public class GetSqlServerRegistrationPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlServerRegistrationName: String? = null

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gstngqnneohmhqcd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL Server registration.
     */
    @JvmName("yrsrxkhecqfnhaea")
    public suspend fun sqlServerRegistrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlServerRegistrationName = mapped
    }

    internal fun build(): GetSqlServerRegistrationPlainArgs = GetSqlServerRegistrationPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlServerRegistrationName = sqlServerRegistrationName ?: throw
            PulumiNullFieldException("sqlServerRegistrationName"),
    )
}
