@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin

import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.FlowPropertiesResponse
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.FlowPropertiesResponse.Companion.toKotlin as flowPropertiesResponseToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Flow].
 */
@PulumiTagMarker
public class FlowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FlowArgs = FlowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FlowArgsBuilder.() -> Unit) {
        val builder = FlowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Flow {
        val builtJavaResource = com.pulumi.azurenative.azuredatatransfer.Flow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Flow(builtJavaResource)
    }
}

/**
 * The flow resource definition.
 * Azure REST API version: 2023-10-11-preview.
 * Other available API versions: 2024-01-25.
 * ## Example Usage
 * ### Creates or updates the flow resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var flow = new AzureNative.AzureDataTransfer.Flow("flow", new()
 *     {
 *         ConnectionName = "testConnection",
 *         FlowName = "testFlow",
 *         Location = "East US",
 *         Properties = new AzureNative.AzureDataTransfer.Inputs.FlowPropertiesArgs
 *         {
 *             Connection = new AzureNative.AzureDataTransfer.Inputs.SelectedResourceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRG/providers/Microsoft.AzureDataTransfer/connections/testConnection",
 *             },
 *             FlowType = "Blob",
 *             StorageAccountName = "testsa",
 *             StorageContainerName = "testcontainer",
 *         },
 *         ResourceGroupName = "testRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredatatransfer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredatatransfer.NewFlow(ctx, "flow", &azuredatatransfer.FlowArgs{
 * 			ConnectionName: pulumi.String("testConnection"),
 * 			FlowName:       pulumi.String("testFlow"),
 * 			Location:       pulumi.String("East US"),
 * 			Properties: &azuredatatransfer.FlowPropertiesArgs{
 * 				Connection: &azuredatatransfer.SelectedResourceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRG/providers/Microsoft.AzureDataTransfer/connections/testConnection"),
 * 				},
 * 				FlowType:             pulumi.String("Blob"),
 * 				StorageAccountName:   pulumi.String("testsa"),
 * 				StorageContainerName: pulumi.String("testcontainer"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredatatransfer.Flow;
 * import com.pulumi.azurenative.azuredatatransfer.FlowArgs;
 * import com.pulumi.azurenative.azuredatatransfer.inputs.FlowPropertiesArgs;
 * import com.pulumi.azurenative.azuredatatransfer.inputs.SelectedResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var flow = new Flow("flow", FlowArgs.builder()
 *             .connectionName("testConnection")
 *             .flowName("testFlow")
 *             .location("East US")
 *             .properties(FlowPropertiesArgs.builder()
 *                 .connection(SelectedResourceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testRG/providers/Microsoft.AzureDataTransfer/connections/testConnection")
 *                     .build())
 *                 .flowType("Blob")
 *                 .storageAccountName("testsa")
 *                 .storageContainerName("testcontainer")
 *                 .build())
 *             .resourceGroupName("testRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredatatransfer:Flow myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureDataTransfer/connections/{connectionName}/flows/{flowName}
 * ```
 */
public class Flow internal constructor(
    override val javaResource: com.pulumi.azurenative.azuredatatransfer.Flow,
) : KotlinCustomResource(javaResource, FlowMapper) {
    /**
     * The managed identity of the flow resource, if configured.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Plan for the resource.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Properties of flow
     */
    public val properties: Output<FlowPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                flowPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FlowMapper : ResourceMapper<Flow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuredatatransfer.Flow::class == javaResource::class

    override fun map(javaResource: Resource): Flow = Flow(
        javaResource as
            com.pulumi.azurenative.azuredatatransfer.Flow,
    )
}

/**
 * @see [Flow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Flow].
 */
public suspend fun flow(name: String, block: suspend FlowResourceBuilder.() -> Unit): Flow {
    val builder = FlowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Flow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun flow(name: String): Flow {
    val builder = FlowResourceBuilder()
    builder.name(name)
    return builder.build()
}
