@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin

import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.PipelinePropertiesResponse
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.PipelinePropertiesResponse.Companion.toKotlin as pipelinePropertiesResponseToKotlin
import com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource =
            com.pulumi.azurenative.azuredatatransfer.Pipeline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Pipeline(builtJavaResource)
    }
}

/**
 * The pipeline resource definition.
 * Azure REST API version: 2023-10-11-preview.
 * Other available API versions: 2024-01-25.
 * ## Example Usage
 * ### Creates or updates the pipeline resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipeline = new AzureNative.AzureDataTransfer.Pipeline("pipeline", new()
 *     {
 *         Location = "East US",
 *         PipelineName = "testPipeline",
 *         Properties = new AzureNative.AzureDataTransfer.Inputs.PipelinePropertiesArgs
 *         {
 *             RemoteCloud = "testdc",
 *         },
 *         ResourceGroupName = "testRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredatatransfer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredatatransfer.NewPipeline(ctx, "pipeline", &azuredatatransfer.PipelineArgs{
 * 			Location:     pulumi.String("East US"),
 * 			PipelineName: pulumi.String("testPipeline"),
 * 			Properties: &azuredatatransfer.PipelinePropertiesArgs{
 * 				RemoteCloud: pulumi.String("testdc"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredatatransfer.Pipeline;
 * import com.pulumi.azurenative.azuredatatransfer.PipelineArgs;
 * import com.pulumi.azurenative.azuredatatransfer.inputs.PipelinePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipeline = new Pipeline("pipeline", PipelineArgs.builder()
 *             .location("East US")
 *             .pipelineName("testPipeline")
 *             .properties(PipelinePropertiesArgs.builder()
 *                 .remoteCloud("testdc")
 *                 .build())
 *             .resourceGroupName("testRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredatatransfer:Pipeline myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureDataTransfer/pipelines/{pipelineName}
 * ```
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.azurenative.azuredatatransfer.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of pipeline
     */
    public val properties: Output<PipelinePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                pipelinePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuredatatransfer.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.azurenative.azuredatatransfer.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
