@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin

import com.pulumi.azurenative.azuredatatransfer.PipelineArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.PipelinePropertiesArgs
import com.pulumi.azurenative.azuredatatransfer.kotlin.inputs.PipelinePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The pipeline resource definition.
 * Azure REST API version: 2023-10-11-preview.
 * Other available API versions: 2024-01-25.
 * ## Example Usage
 * ### Creates or updates the pipeline resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var pipeline = new AzureNative.AzureDataTransfer.Pipeline("pipeline", new()
 *     {
 *         Location = "East US",
 *         PipelineName = "testPipeline",
 *         Properties = new AzureNative.AzureDataTransfer.Inputs.PipelinePropertiesArgs
 *         {
 *             RemoteCloud = "testdc",
 *         },
 *         ResourceGroupName = "testRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuredatatransfer/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuredatatransfer.NewPipeline(ctx, "pipeline", &azuredatatransfer.PipelineArgs{
 * 			Location:     pulumi.String("East US"),
 * 			PipelineName: pulumi.String("testPipeline"),
 * 			Properties: &azuredatatransfer.PipelinePropertiesArgs{
 * 				RemoteCloud: pulumi.String("testdc"),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuredatatransfer.Pipeline;
 * import com.pulumi.azurenative.azuredatatransfer.PipelineArgs;
 * import com.pulumi.azurenative.azuredatatransfer.inputs.PipelinePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var pipeline = new Pipeline("pipeline", PipelineArgs.builder()
 *             .location("East US")
 *             .pipelineName("testPipeline")
 *             .properties(PipelinePropertiesArgs.builder()
 *                 .remoteCloud("testdc")
 *                 .build())
 *             .resourceGroupName("testRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuredatatransfer:Pipeline myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureDataTransfer/pipelines/{pipelineName}
 * ```
 * @property location The geo-location where the resource lives
 * @property pipelineName The name for the pipeline that is to be requested.
 * @property properties Properties of pipeline
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class PipelineArgs(
    public val location: Output<String>? = null,
    public val pipelineName: Output<String>? = null,
    public val properties: Output<PipelinePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.PipelineArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.PipelineArgs =
        com.pulumi.azurenative.azuredatatransfer.PipelineArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .pipelineName(pipelineName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PipelineArgs].
 */
@PulumiTagMarker
public class PipelineArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var pipelineName: Output<String>? = null

    private var properties: Output<PipelinePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mirepllrwxjxkloh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name for the pipeline that is to be requested.
     */
    @JvmName("oretadymlvuadbol")
    public suspend fun pipelineName(`value`: Output<String>) {
        this.pipelineName = value
    }

    /**
     * @param value Properties of pipeline
     */
    @JvmName("ebujajpwdacshprj")
    public suspend fun properties(`value`: Output<PipelinePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("spgrjpvcxlnpkwdx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yuvqsnedmwbrxybt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("argfwokftfpiyogt")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name for the pipeline that is to be requested.
     */
    @JvmName("pvdwgwhspmbbrqvt")
    public suspend fun pipelineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineName = mapped
    }

    /**
     * @param value Properties of pipeline
     */
    @JvmName("iuramfoouqlexxtf")
    public suspend fun properties(`value`: PipelinePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of pipeline
     */
    @JvmName("bkdrllhnqltvruhe")
    public suspend fun properties(argument: suspend PipelinePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PipelinePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jctlkxswwysmsrue")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pwwdoxqaqndepsya")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("eiukqfdioojjctsv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PipelineArgs = PipelineArgs(
        location = location,
        pipelineName = pipelineName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
