@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
 */
public enum class ManagedServiceIdentityType(
    public val javaValue: com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType> {
    None(com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.enums.ManagedServiceIdentityType): ManagedServiceIdentityType =
            ManagedServiceIdentityType.values().first { it.javaValue == javaType }
    }
}
