@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.PipelinePropertiesArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.FlowType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of pipeline
 * @property displayName Display name of this pipeline
 * @property flowTypes The flow types allowed for this pipeline
 * @property policies The policies for this pipeline
 * @property remoteCloud Remote cloud of the data to be transferred or received
 * @property subscribers Subscribers of this resource
 */
public data class PipelinePropertiesArgs(
    public val displayName: Output<String>? = null,
    public val flowTypes: Output<List<Either<String, FlowType>>>? = null,
    public val policies: Output<List<String>>? = null,
    public val remoteCloud: Output<String>,
    public val subscribers: Output<List<SubscriberArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.PipelinePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.PipelinePropertiesArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.PipelinePropertiesArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .flowTypes(
                flowTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .policies(policies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .remoteCloud(remoteCloud.applyValue({ args0 -> args0 }))
            .subscribers(
                subscribers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PipelinePropertiesArgs].
 */
@PulumiTagMarker
public class PipelinePropertiesArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var flowTypes: Output<List<Either<String, FlowType>>>? = null

    private var policies: Output<List<String>>? = null

    private var remoteCloud: Output<String>? = null

    private var subscribers: Output<List<SubscriberArgs>>? = null

    /**
     * @param value Display name of this pipeline
     */
    @JvmName("aclgwtswalwmgokh")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The flow types allowed for this pipeline
     */
    @JvmName("ajtdqaepnbokpbjd")
    public suspend fun flowTypes(`value`: Output<List<Either<String, FlowType>>>) {
        this.flowTypes = value
    }

    @JvmName("qqykoxqwhievelyt")
    public suspend fun flowTypes(vararg values: Output<Either<String, FlowType>>) {
        this.flowTypes = Output.all(values.asList())
    }

    /**
     * @param values The flow types allowed for this pipeline
     */
    @JvmName("etojnwiunbpapemw")
    public suspend fun flowTypes(values: List<Output<Either<String, FlowType>>>) {
        this.flowTypes = Output.all(values)
    }

    /**
     * @param value The policies for this pipeline
     */
    @JvmName("lcagsoctcoeibxgv")
    public suspend fun policies(`value`: Output<List<String>>) {
        this.policies = value
    }

    @JvmName("iiyiagpmdjctynkf")
    public suspend fun policies(vararg values: Output<String>) {
        this.policies = Output.all(values.asList())
    }

    /**
     * @param values The policies for this pipeline
     */
    @JvmName("hoybtjagnmounven")
    public suspend fun policies(values: List<Output<String>>) {
        this.policies = Output.all(values)
    }

    /**
     * @param value Remote cloud of the data to be transferred or received
     */
    @JvmName("vniktpwjfjslpvqe")
    public suspend fun remoteCloud(`value`: Output<String>) {
        this.remoteCloud = value
    }

    /**
     * @param value Subscribers of this resource
     */
    @JvmName("fqpgqvdpnlwfsyaw")
    public suspend fun subscribers(`value`: Output<List<SubscriberArgs>>) {
        this.subscribers = value
    }

    @JvmName("fpgktcgkieqhchmd")
    public suspend fun subscribers(vararg values: Output<SubscriberArgs>) {
        this.subscribers = Output.all(values.asList())
    }

    /**
     * @param values Subscribers of this resource
     */
    @JvmName("tfsbwwempryddtnq")
    public suspend fun subscribers(values: List<Output<SubscriberArgs>>) {
        this.subscribers = Output.all(values)
    }

    /**
     * @param value Display name of this pipeline
     */
    @JvmName("gdxeujrioacfnusr")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The flow types allowed for this pipeline
     */
    @JvmName("catwhkpshqqbrlaq")
    public suspend fun flowTypes(`value`: List<Either<String, FlowType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flowTypes = mapped
    }

    /**
     * @param values The flow types allowed for this pipeline
     */
    @JvmName("urmhqdwrvlmgsypj")
    public suspend fun flowTypes(vararg values: Either<String, FlowType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.flowTypes = mapped
    }

    /**
     * @param value The policies for this pipeline
     */
    @JvmName("kkgfgnjggnvwkwmg")
    public suspend fun policies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param values The policies for this pipeline
     */
    @JvmName("wuomwyufocniratu")
    public suspend fun policies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param value Remote cloud of the data to be transferred or received
     */
    @JvmName("nvggdrvjvvnjuudd")
    public suspend fun remoteCloud(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.remoteCloud = mapped
    }

    /**
     * @param value Subscribers of this resource
     */
    @JvmName("nxfppqdpasoqylkp")
    public suspend fun subscribers(`value`: List<SubscriberArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscribers = mapped
    }

    /**
     * @param argument Subscribers of this resource
     */
    @JvmName("jjhlxcfclacwomyp")
    public suspend fun subscribers(argument: List<suspend SubscriberArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubscriberArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param argument Subscribers of this resource
     */
    @JvmName("hgocjgwwadcllgty")
    public suspend fun subscribers(vararg argument: suspend SubscriberArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubscriberArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param argument Subscribers of this resource
     */
    @JvmName("gpffvbknudidljuq")
    public suspend fun subscribers(argument: suspend SubscriberArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubscriberArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.subscribers = mapped
    }

    /**
     * @param values Subscribers of this resource
     */
    @JvmName("fffuvbacywfcastd")
    public suspend fun subscribers(vararg values: SubscriberArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subscribers = mapped
    }

    internal fun build(): PipelinePropertiesArgs = PipelinePropertiesArgs(
        displayName = displayName,
        flowTypes = flowTypes,
        policies = policies,
        remoteCloud = remoteCloud ?: throw PulumiNullFieldException("remoteCloud"),
        subscribers = subscribers,
    )
}
