@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of flow
 * @property connection The connection associated with this flow
 * @property dataType Transfer Storage Blobs or Tables
 * @property flowId Dataflow GUID associated with this flow
 * @property flowType The flow type for this flow
 * @property keyVaultUri AME, PME, or TORUS only! AKV Chain Containing SAS Token
 * @property linkStatus Link status of the current flow
 * @property linkedFlowId Resource ID of the linked flow
 * @property policies The policies for this flow
 * @property provisioningState Provisioning state of the flow
 * @property schema The selected schema for this flow
 * @property serviceBusQueueId Service Bus Queue ID
 * @property status Status of the current flow
 * @property storageAccountId Storage Account ID
 * @property storageAccountName Storage Account
 * @property storageContainerName Storage Container Name
 */
public data class FlowPropertiesResponse(
    public val connection: SelectedResourceResponse? = null,
    public val dataType: String? = null,
    public val flowId: String,
    public val flowType: String? = null,
    public val keyVaultUri: String? = null,
    public val linkStatus: String,
    public val linkedFlowId: String,
    public val policies: List<String>? = null,
    public val provisioningState: String,
    public val schema: SchemaResponse? = null,
    public val serviceBusQueueId: String? = null,
    public val status: String? = null,
    public val storageAccountId: String? = null,
    public val storageAccountName: String? = null,
    public val storageContainerName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.FlowPropertiesResponse): FlowPropertiesResponse = FlowPropertiesResponse(
            connection = javaType.connection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SelectedResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            flowId = javaType.flowId(),
            flowType = javaType.flowType().map({ args0 -> args0 }).orElse(null),
            keyVaultUri = javaType.keyVaultUri().map({ args0 -> args0 }).orElse(null),
            linkStatus = javaType.linkStatus(),
            linkedFlowId = javaType.linkedFlowId(),
            policies = javaType.policies().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            schema = javaType.schema().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SchemaResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceBusQueueId = javaType.serviceBusQueueId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
            storageContainerName = javaType.storageContainerName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
