@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The flow resource definition.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property identity The managed identity of the flow resource, if configured.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property plan Plan for the resource.
 * @property properties Properties of flow
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFlowResult(
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val plan: PlanResponse? = null,
    public val properties: FlowPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.GetFlowResult): GetFlowResult = GetFlowResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            plan = javaType.plan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.PlanResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.FlowPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
