@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Pending connection object
 * @property approver Approver of this connection request
 * @property dateSubmitted The timestamp that this connection request was submitted at
 * @property direction Direction of data movement
 * @property flowTypes The flow types being requested for this connection
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property justification Justification for the connection request
 * @property linkStatus Link status of the current connection
 * @property linkedConnectionId Resource ID of the linked connection
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property pin PIN to link requests together
 * @property pipeline Pipeline to use to transfer data
 * @property policies The policies for this connection
 * @property primaryContact The primary contact for this connection request
 * @property provisioningState Provisioning state of the connection
 * @property remoteSubscriptionId Subscription ID to link cloud subscriptions together
 * @property requirementId Requirement ID of the connection
 * @property schemas The schemas for this connection
 * @property secondaryContacts The secondary contacts for this connection request
 * @property status Status of the connection
 * @property statusReason Reason for status
 * @property subscriptionId Subscription ID of the pending connection.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class PendingConnectionResponse(
    public val approver: String,
    public val dateSubmitted: String,
    public val direction: String? = null,
    public val flowTypes: List<String>? = null,
    public val id: String,
    public val justification: String? = null,
    public val linkStatus: String,
    public val linkedConnectionId: String,
    public val location: String,
    public val name: String,
    public val pin: String? = null,
    public val pipeline: String,
    public val policies: List<String>? = null,
    public val primaryContact: String? = null,
    public val provisioningState: String,
    public val remoteSubscriptionId: String? = null,
    public val requirementId: String? = null,
    public val schemas: List<SchemaResponse>? = null,
    public val secondaryContacts: List<String>? = null,
    public val status: String,
    public val statusReason: String,
    public val subscriptionId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.PendingConnectionResponse): PendingConnectionResponse = PendingConnectionResponse(
            approver = javaType.approver(),
            dateSubmitted = javaType.dateSubmitted(),
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            flowTypes = javaType.flowTypes().map({ args0 -> args0 }),
            id = javaType.id(),
            justification = javaType.justification().map({ args0 -> args0 }).orElse(null),
            linkStatus = javaType.linkStatus(),
            linkedConnectionId = javaType.linkedConnectionId(),
            location = javaType.location(),
            name = javaType.name(),
            pin = javaType.pin().map({ args0 -> args0 }).orElse(null),
            pipeline = javaType.pipeline(),
            policies = javaType.policies().map({ args0 -> args0 }),
            primaryContact = javaType.primaryContact().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            remoteSubscriptionId = javaType.remoteSubscriptionId().map({ args0 -> args0 }).orElse(null),
            requirementId = javaType.requirementId().map({ args0 -> args0 }).orElse(null),
            schemas = javaType.schemas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SchemaResponse.Companion.toKotlin(args0)
                })
            }),
            secondaryContacts = javaType.secondaryContacts().map({ args0 -> args0 }),
            status = javaType.status(),
            statusReason = javaType.statusReason(),
            subscriptionId = javaType.subscriptionId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
