@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connection body inside a pipeline
 * @property etag Connection etag inside pipeline
 * @property id Connection id inside pipeline
 * @property location Connection location inside pipeline
 * @property name Connection name inside pipeline
 * @property properties Connection properties inside pipeline
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type Connection type inside pipeline
 */
public data class PipelineConnectionResponse(
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val properties: PipelineConnectionResponseProperties? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.PipelineConnectionResponse): PipelineConnectionResponse = PipelineConnectionResponse(
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            properties = javaType.properties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.PipelineConnectionResponseProperties.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
