@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of pipeline
 * @property connections Connections associated with pipeline
 * @property displayName Display name of this pipeline
 * @property flowTypes The flow types allowed for this pipeline
 * @property policies The policies for this pipeline
 * @property provisioningState Provisioning state of the pipeline
 * @property remoteCloud Remote cloud of the data to be transferred or received
 * @property subscribers Subscribers of this resource
 */
public data class PipelinePropertiesResponse(
    public val connections: List<PipelineConnectionResponse>,
    public val displayName: String? = null,
    public val flowTypes: List<String>? = null,
    public val policies: List<String>? = null,
    public val provisioningState: String,
    public val remoteCloud: String,
    public val subscribers: List<SubscriberResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.PipelinePropertiesResponse): PipelinePropertiesResponse = PipelinePropertiesResponse(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.PipelineConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            flowTypes = javaType.flowTypes().map({ args0 -> args0 }),
            policies = javaType.policies().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
            remoteCloud = javaType.remoteCloud(),
            subscribers = javaType.subscribers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.SubscriberResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
