@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A resource selected from ARM
 * @property id Id of the connection
 * @property location Location of the connection
 * @property name Name of the connection
 * @property subscriptionName Name of the subscription with the connection
 */
public data class SelectedResourceResponse(
    public val id: String,
    public val location: String? = null,
    public val name: String? = null,
    public val subscriptionName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.SelectedResourceResponse): SelectedResourceResponse = SelectedResourceResponse(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            subscriptionName = javaType.subscriptionName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
