@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin

import com.pulumi.azurenative.azurefleet.AzurefleetFunctions.getFleetPlain
import com.pulumi.azurenative.azurefleet.kotlin.inputs.GetFleetPlainArgs
import com.pulumi.azurenative.azurefleet.kotlin.inputs.GetFleetPlainArgsBuilder
import com.pulumi.azurenative.azurefleet.kotlin.outputs.GetFleetResult
import com.pulumi.azurenative.azurefleet.kotlin.outputs.GetFleetResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object AzurefleetFunctions {
    /**
     * Get a Fleet
     * Azure REST API version: 2024-05-01-preview.
     * Other available API versions: 2023-11-01-preview.
     * @param argument null
     * @return An Compute Fleet resource
     */
    public suspend fun getFleet(argument: GetFleetPlainArgs): GetFleetResult =
        toKotlin(getFleetPlain(argument.toJava()).await())

    /**
     * @see [getFleet].
     * @param fleetName The name of the Compute Fleet
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An Compute Fleet resource
     */
    public suspend fun getFleet(fleetName: String, resourceGroupName: String): GetFleetResult {
        val argument = GetFleetPlainArgs(
            fleetName = fleetName,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getFleetPlain(argument.toJava()).await())
    }

    /**
     * @see [getFleet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azurefleet&#46;kotlin&#46;inputs&#46;GetFleetPlainArgs].
     * @return An Compute Fleet resource
     */
    public suspend fun getFleet(argument: suspend GetFleetPlainArgsBuilder.() -> Unit): GetFleetResult {
        val builder = GetFleetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getFleetPlain(builtArgument.toJava()).await())
    }
}
