@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin

import com.pulumi.azurenative.azurefleet.kotlin.outputs.ComputeProfileResponse
import com.pulumi.azurenative.azurefleet.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.azurefleet.kotlin.outputs.PlanResponse
import com.pulumi.azurenative.azurefleet.kotlin.outputs.RegularPriorityProfileResponse
import com.pulumi.azurenative.azurefleet.kotlin.outputs.SpotPriorityProfileResponse
import com.pulumi.azurenative.azurefleet.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurefleet.kotlin.outputs.VmSizeProfileResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.azurefleet.kotlin.outputs.ComputeProfileResponse.Companion.toKotlin as computeProfileResponseToKotlin
import com.pulumi.azurenative.azurefleet.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.azurefleet.kotlin.outputs.PlanResponse.Companion.toKotlin as planResponseToKotlin
import com.pulumi.azurenative.azurefleet.kotlin.outputs.RegularPriorityProfileResponse.Companion.toKotlin as regularPriorityProfileResponseToKotlin
import com.pulumi.azurenative.azurefleet.kotlin.outputs.SpotPriorityProfileResponse.Companion.toKotlin as spotPriorityProfileResponseToKotlin
import com.pulumi.azurenative.azurefleet.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.azurefleet.kotlin.outputs.VmSizeProfileResponse.Companion.toKotlin as vmSizeProfileResponseToKotlin

/**
 * Builder for [Fleet].
 */
@PulumiTagMarker
public class FleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetArgs = FleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetArgsBuilder.() -> Unit) {
        val builder = FleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Fleet {
        val builtJavaResource = com.pulumi.azurenative.azurefleet.Fleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fleet(builtJavaResource)
    }
}

/**
 * An Compute Fleet resource
 * Azure REST API version: 2024-05-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurefleet:Fleet testFleet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureFleet/fleets/{fleetName}
 * ```
 */
public class Fleet internal constructor(
    override val javaResource: com.pulumi.azurenative.azurefleet.Fleet,
) : KotlinCustomResource(javaResource, FleetMapper) {
    /**
     * Compute Profile to use for running user's workloads.
     */
    public val computeProfile: Output<ComputeProfileResponse>
        get() = javaResource.computeProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                computeProfileResponseToKotlin(args0)
            })
        })

    /**
     * The managed service identities assigned to this resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Details of the resource plan.
     */
    public val plan: Output<PlanResponse>?
        get() = javaResource.plan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    planResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Configuration Options for Regular instances in Compute Fleet.
     */
    public val regularPriorityProfile: Output<RegularPriorityProfileResponse>?
        get() = javaResource.regularPriorityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> regularPriorityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Configuration Options for Spot instances in Compute Fleet.
     */
    public val spotPriorityProfile: Output<SpotPriorityProfileResponse>?
        get() = javaResource.spotPriorityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> spotPriorityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List of VM sizes supported for Compute Fleet
     */
    public val vmSizesProfile: Output<List<VmSizeProfileResponse>>
        get() = javaResource.vmSizesProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> vmSizeProfileResponseToKotlin(args0) })
            })
        })

    /**
     * Zones in which the Compute Fleet is available
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object FleetMapper : ResourceMapper<Fleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurefleet.Fleet::class == javaResource::class

    override fun map(javaResource: Resource): Fleet = Fleet(
        javaResource as
            com.pulumi.azurenative.azurefleet.Fleet,
    )
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fleet].
 */
public suspend fun fleet(name: String, block: suspend FleetResourceBuilder.() -> Unit): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleet(name: String): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
