@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin

import com.pulumi.azurenative.azurefleet.FleetArgs.builder
import com.pulumi.azurenative.azurefleet.kotlin.inputs.ComputeProfileArgs
import com.pulumi.azurenative.azurefleet.kotlin.inputs.ComputeProfileArgsBuilder
import com.pulumi.azurenative.azurefleet.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.azurefleet.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.azurefleet.kotlin.inputs.PlanArgs
import com.pulumi.azurenative.azurefleet.kotlin.inputs.PlanArgsBuilder
import com.pulumi.azurenative.azurefleet.kotlin.inputs.RegularPriorityProfileArgs
import com.pulumi.azurenative.azurefleet.kotlin.inputs.RegularPriorityProfileArgsBuilder
import com.pulumi.azurenative.azurefleet.kotlin.inputs.SpotPriorityProfileArgs
import com.pulumi.azurenative.azurefleet.kotlin.inputs.SpotPriorityProfileArgsBuilder
import com.pulumi.azurenative.azurefleet.kotlin.inputs.VmSizeProfileArgs
import com.pulumi.azurenative.azurefleet.kotlin.inputs.VmSizeProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Compute Fleet resource
 * Azure REST API version: 2024-05-01-preview.
 * Other available API versions: 2023-11-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurefleet:Fleet testFleet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureFleet/fleets/{fleetName}
 * ```
 * @property computeProfile Compute Profile to use for running user's workloads.
 * @property fleetName The name of the Compute Fleet
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property plan Details of the resource plan.
 * @property regularPriorityProfile Configuration Options for Regular instances in Compute Fleet.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spotPriorityProfile Configuration Options for Spot instances in Compute Fleet.
 * @property tags Resource tags.
 * @property vmSizesProfile List of VM sizes supported for Compute Fleet
 * @property zones Zones in which the Compute Fleet is available
 */
public data class FleetArgs(
    public val computeProfile: Output<ComputeProfileArgs>? = null,
    public val fleetName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val plan: Output<PlanArgs>? = null,
    public val regularPriorityProfile: Output<RegularPriorityProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val spotPriorityProfile: Output<SpotPriorityProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vmSizesProfile: Output<List<VmSizeProfileArgs>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.FleetArgs> {
    override fun toJava(): com.pulumi.azurenative.azurefleet.FleetArgs =
        com.pulumi.azurenative.azurefleet.FleetArgs.builder()
            .computeProfile(computeProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fleetName(fleetName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regularPriorityProfile(
                regularPriorityProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .spotPriorityProfile(
                spotPriorityProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vmSizesProfile(
                vmSizesProfile?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var computeProfile: Output<ComputeProfileArgs>? = null

    private var fleetName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var plan: Output<PlanArgs>? = null

    private var regularPriorityProfile: Output<RegularPriorityProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var spotPriorityProfile: Output<SpotPriorityProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vmSizesProfile: Output<List<VmSizeProfileArgs>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Compute Profile to use for running user's workloads.
     */
    @JvmName("dmnmncqlkjprliqg")
    public suspend fun computeProfile(`value`: Output<ComputeProfileArgs>) {
        this.computeProfile = value
    }

    /**
     * @param value The name of the Compute Fleet
     */
    @JvmName("cyuyoghjksuuglgb")
    public suspend fun fleetName(`value`: Output<String>) {
        this.fleetName = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("ssxbrxfagaeuqnyc")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cbnmkgdlddlptpgw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Details of the resource plan.
     */
    @JvmName("iwehukycvwjnkfdj")
    public suspend fun plan(`value`: Output<PlanArgs>) {
        this.plan = value
    }

    /**
     * @param value Configuration Options for Regular instances in Compute Fleet.
     */
    @JvmName("eoevomsghdalbyos")
    public suspend fun regularPriorityProfile(`value`: Output<RegularPriorityProfileArgs>) {
        this.regularPriorityProfile = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hiqhndmulgwpgljk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Configuration Options for Spot instances in Compute Fleet.
     */
    @JvmName("dtmchnsoutuoaals")
    public suspend fun spotPriorityProfile(`value`: Output<SpotPriorityProfileArgs>) {
        this.spotPriorityProfile = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hkgnslskysshjclc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of VM sizes supported for Compute Fleet
     */
    @JvmName("risdvsuljacvfhrq")
    public suspend fun vmSizesProfile(`value`: Output<List<VmSizeProfileArgs>>) {
        this.vmSizesProfile = value
    }

    @JvmName("eqjcmlifdgpmyfof")
    public suspend fun vmSizesProfile(vararg values: Output<VmSizeProfileArgs>) {
        this.vmSizesProfile = Output.all(values.asList())
    }

    /**
     * @param values List of VM sizes supported for Compute Fleet
     */
    @JvmName("vrfvpkneahtmgdws")
    public suspend fun vmSizesProfile(values: List<Output<VmSizeProfileArgs>>) {
        this.vmSizesProfile = Output.all(values)
    }

    /**
     * @param value Zones in which the Compute Fleet is available
     */
    @JvmName("ahsthyqllpuhtkex")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("aejmvaydovrbxplg")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Zones in which the Compute Fleet is available
     */
    @JvmName("etdlskrwjnbpappo")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Compute Profile to use for running user's workloads.
     */
    @JvmName("hlsseimbmeraflir")
    public suspend fun computeProfile(`value`: ComputeProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeProfile = mapped
    }

    /**
     * @param argument Compute Profile to use for running user's workloads.
     */
    @JvmName("hudtaerljwdxfivr")
    public suspend fun computeProfile(argument: suspend ComputeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeProfile = mapped
    }

    /**
     * @param value The name of the Compute Fleet
     */
    @JvmName("qqpysplkfpkvbmgs")
    public suspend fun fleetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetName = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("vtsypxjxdacubiql")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("rqsiowcojyitsowt")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tioqnpiafokgkmak")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Details of the resource plan.
     */
    @JvmName("gdlieemylqltnqks")
    public suspend fun plan(`value`: PlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument Details of the resource plan.
     */
    @JvmName("vmbdyrhytmnsxisl")
    public suspend fun plan(argument: suspend PlanArgsBuilder.() -> Unit) {
        val toBeMapped = PlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value Configuration Options for Regular instances in Compute Fleet.
     */
    @JvmName("sihpuxdqgmtfxkqy")
    public suspend fun regularPriorityProfile(`value`: RegularPriorityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regularPriorityProfile = mapped
    }

    /**
     * @param argument Configuration Options for Regular instances in Compute Fleet.
     */
    @JvmName("lijnjdcpjcuigdik")
    public suspend fun regularPriorityProfile(argument: suspend RegularPriorityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = RegularPriorityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.regularPriorityProfile = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gmcntfdlqtntienq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Configuration Options for Spot instances in Compute Fleet.
     */
    @JvmName("ptxejltmarlwveio")
    public suspend fun spotPriorityProfile(`value`: SpotPriorityProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotPriorityProfile = mapped
    }

    /**
     * @param argument Configuration Options for Spot instances in Compute Fleet.
     */
    @JvmName("cfcupqsougsyikkc")
    public suspend fun spotPriorityProfile(argument: suspend SpotPriorityProfileArgsBuilder.() -> Unit) {
        val toBeMapped = SpotPriorityProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spotPriorityProfile = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lopmilnvmfonpwys")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("cfvsdtflhmdodyvj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value List of VM sizes supported for Compute Fleet
     */
    @JvmName("skjgcghehajiiowc")
    public suspend fun vmSizesProfile(`value`: List<VmSizeProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSizesProfile = mapped
    }

    /**
     * @param argument List of VM sizes supported for Compute Fleet
     */
    @JvmName("nkxexoggoiuwiqgr")
    public suspend fun vmSizesProfile(argument: List<suspend VmSizeProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VmSizeProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vmSizesProfile = mapped
    }

    /**
     * @param argument List of VM sizes supported for Compute Fleet
     */
    @JvmName("srkofubuutlqjbsx")
    public suspend fun vmSizesProfile(vararg argument: suspend VmSizeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VmSizeProfileArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vmSizesProfile = mapped
    }

    /**
     * @param argument List of VM sizes supported for Compute Fleet
     */
    @JvmName("agiipnlntppqpgid")
    public suspend fun vmSizesProfile(argument: suspend VmSizeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VmSizeProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vmSizesProfile = mapped
    }

    /**
     * @param values List of VM sizes supported for Compute Fleet
     */
    @JvmName("ybbyunlyfofweqoe")
    public suspend fun vmSizesProfile(vararg values: VmSizeProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSizesProfile = mapped
    }

    /**
     * @param value Zones in which the Compute Fleet is available
     */
    @JvmName("gbtqcjpnfslidbwv")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Zones in which the Compute Fleet is available
     */
    @JvmName("ujjcskgxlbssqntb")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        computeProfile = computeProfile,
        fleetName = fleetName,
        identity = identity,
        location = location,
        plan = plan,
        regularPriorityProfile = regularPriorityProfile,
        resourceGroupName = resourceGroupName,
        spotPriorityProfile = spotPriorityProfile,
        tags = tags,
        vmSizesProfile = vmSizesProfile,
        zones = zones,
    )
}
