@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies how the virtual machines in the scale set should be created. The only allowed value is: **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you also use the imageReference element described above. If you are using a marketplace image, you  also use the plan element previously described.
 */
public enum class DiskCreateOptionTypes(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.DiskCreateOptionTypes,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.DiskCreateOptionTypes> {
    FromImage(com.pulumi.azurenative.azurefleet.enums.DiskCreateOptionTypes.FromImage),
    Empty(com.pulumi.azurenative.azurefleet.enums.DiskCreateOptionTypes.Empty),
    Attach(com.pulumi.azurenative.azurefleet.enums.DiskCreateOptionTypes.Attach),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.DiskCreateOptionTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.DiskCreateOptionTypes): DiskCreateOptionTypes = DiskCreateOptionTypes.values().first { it.javaValue == javaType }
    }
}
