@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies whether OS Disk should be deleted or detached upon VMSS Flex deletion (This feature is available for VMSS with Flexible OrchestrationMode only). <br><br> Possible values: <br><br> **Delete** If this value is used, the OS disk is deleted when VMSS Flex VM is deleted.<br><br> **Detach** If this value is used, the OS disk is retained after VMSS Flex VM is deleted. <br><br> The default value is set to **Delete**. For an Ephemeral OS Disk, the default value is set to **Delete**. User cannot change the delete option for Ephemeral OS Disk.
 */
public enum class DiskDeleteOptionTypes(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.DiskDeleteOptionTypes,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.DiskDeleteOptionTypes> {
    Delete(com.pulumi.azurenative.azurefleet.enums.DiskDeleteOptionTypes.Delete),
    Detach(com.pulumi.azurenative.azurefleet.enums.DiskDeleteOptionTypes.Detach),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.DiskDeleteOptionTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.DiskDeleteOptionTypes): DiskDeleteOptionTypes = DiskDeleteOptionTypes.values().first { it.javaValue == javaType }
    }
}
