@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Domain name label scope.The concatenation of the hashed domain name label that generated according to the policy from domain name label scope and vm index will be the domain name labels of the PublicIPAddress resources that will be created
 */
public enum class DomainNameLabelScopeTypes(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes> {
    TenantReuse(com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes.TenantReuse),
    SubscriptionReuse(com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes.SubscriptionReuse),
    ResourceGroupReuse(com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes.ResourceGroupReuse),
    NoReuse(com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes.NoReuse),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.DomainNameLabelScopeTypes): DomainNameLabelScopeTypes =
            DomainNameLabelScopeTypes.values().first { it.javaValue == javaType }
    }
}
