@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Eviction Policy to follow when evicting Spot VMs.
 */
public enum class EvictionPolicy(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.EvictionPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.EvictionPolicy> {
    /**
     * When evicted, the Spot VM will be deleted and the corresponding capacity will be updated to reflect this.
     */
    Delete(com.pulumi.azurenative.azurefleet.enums.EvictionPolicy.Delete),

    /**
     * When evicted, the Spot VM will be deallocated/stopped
     */
    Deallocate(com.pulumi.azurenative.azurefleet.enums.EvictionPolicy.Deallocate),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.EvictionPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.EvictionPolicy): EvictionPolicy = EvictionPolicy.values().first { it.javaValue == javaType }
    }
}
