@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Available from Api-Version 2019-07-01 onwards, it represents whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values are: 'IPv4' and 'IPv6'.
 */
public enum class IPVersion(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.IPVersion,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.IPVersion> {
    IPv4(com.pulumi.azurenative.azurefleet.enums.IPVersion.IPv4),
    IPv6(com.pulumi.azurenative.azurefleet.enums.IPVersion.IPv6),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.IPVersion = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.IPVersion): IPVersion =
            IPVersion.values().first { it.javaValue == javaType }
    }
}
