@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of VM Guest Patch Assessment for the IaaS virtual machine.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - You control the timing of patch assessments on a virtual machine. <br /><br /> **AutomaticByPlatform** - The platform will trigger periodic patch assessments. The property provisionVMAgent must be true.
 */
public enum class LinuxPatchAssessmentMode(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.LinuxPatchAssessmentMode,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.LinuxPatchAssessmentMode> {
    ImageDefault(com.pulumi.azurenative.azurefleet.enums.LinuxPatchAssessmentMode.ImageDefault),
    AutomaticByPlatform(com.pulumi.azurenative.azurefleet.enums.LinuxPatchAssessmentMode.AutomaticByPlatform),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.LinuxPatchAssessmentMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.LinuxPatchAssessmentMode): LinuxPatchAssessmentMode =
            LinuxPatchAssessmentMode.values().first { it.javaValue == javaType }
    }
}
