@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual machines associated to virtual machine scale set with OrchestrationMode as Flexible.<br /><br /> Possible values are:<br /><br /> **ImageDefault** - The virtual machine's default patching configuration is used. <br /><br /> **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform. The property provisionVMAgent must be true
 */
public enum class LinuxVMGuestPatchMode(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.LinuxVMGuestPatchMode,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.LinuxVMGuestPatchMode> {
    ImageDefault(com.pulumi.azurenative.azurefleet.enums.LinuxVMGuestPatchMode.ImageDefault),
    AutomaticByPlatform(com.pulumi.azurenative.azurefleet.enums.LinuxVMGuestPatchMode.AutomaticByPlatform),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.LinuxVMGuestPatchMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.LinuxVMGuestPatchMode): LinuxVMGuestPatchMode = LinuxVMGuestPatchMode.values().first { it.javaValue == javaType }
    }
}
