@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode that ProxyAgent will execute on if the feature is enabled. ProxyAgent will start to audit or monitor but not enforce access control over requests to host endpoints in Audit mode, while in Enforce mode it will enforce access control. The default value is Enforce mode.
 */
public enum class Mode(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.Mode,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.Mode> {
    Audit(com.pulumi.azurenative.azurefleet.enums.Mode.Audit),
    Enforce(com.pulumi.azurenative.azurefleet.enums.Mode.Enforce),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.Mode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.Mode): Mode =
            Mode.values().first { it.javaValue == javaType }
    }
}
