@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allocation strategy to follow when determining the VM sizes distribution for Regular VMs.
 */
public enum class RegularPriorityAllocationStrategy(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.RegularPriorityAllocationStrategy,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.RegularPriorityAllocationStrategy> {
    /**
     * Default. VM sizes distribution will be determined to optimize for price.
     */
    LowestPrice(com.pulumi.azurenative.azurefleet.enums.RegularPriorityAllocationStrategy.LowestPrice),

    /**
     * VM sizes distribution will be determined to optimize for the 'priority' as specified for each vm size.
     */
    Prioritized(com.pulumi.azurenative.azurefleet.enums.RegularPriorityAllocationStrategy.Prioritized),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.RegularPriorityAllocationStrategy =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.RegularPriorityAllocationStrategy): RegularPriorityAllocationStrategy =
            RegularPriorityAllocationStrategy.values().first { it.javaValue == javaType }
    }
}
