@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob, VMGuestStateOnly for encryption of just the VMGuestState blob, and NonPersistedTPM for not persisting firmware state in the VMGuestState blob.. **Note:** It can be set for only Confidential VMs.
 */
public enum class SecurityEncryptionTypes(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.SecurityEncryptionTypes,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.SecurityEncryptionTypes> {
    VMGuestStateOnly(com.pulumi.azurenative.azurefleet.enums.SecurityEncryptionTypes.VMGuestStateOnly),
    DiskWithVMGuestState(com.pulumi.azurenative.azurefleet.enums.SecurityEncryptionTypes.DiskWithVMGuestState),
    NonPersistedTPM(com.pulumi.azurenative.azurefleet.enums.SecurityEncryptionTypes.NonPersistedTPM),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.SecurityEncryptionTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.SecurityEncryptionTypes): SecurityEncryptionTypes =
            SecurityEncryptionTypes.values().first { it.javaValue == javaType }
    }
}
