@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Allocation strategy to follow when determining the VM sizes distribution for Spot VMs.
 */
public enum class SpotAllocationStrategy(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.SpotAllocationStrategy,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.SpotAllocationStrategy> {
    /**
     * Default. VM sizes distribution will be determined to optimize for both price and capacity.
     */
    PriceCapacityOptimized(com.pulumi.azurenative.azurefleet.enums.SpotAllocationStrategy.PriceCapacityOptimized),

    /**
     * VM sizes distribution will be determined to optimize for price. Note: Capacity will still be considered here but will be given much less weight.
     */
    LowestPrice(com.pulumi.azurenative.azurefleet.enums.SpotAllocationStrategy.LowestPrice),

    /**
     * VM sizes distribution will be determined to optimize for capacity.
     */
    CapacityOptimized(com.pulumi.azurenative.azurefleet.enums.SpotAllocationStrategy.CapacityOptimized),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.SpotAllocationStrategy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.SpotAllocationStrategy): SpotAllocationStrategy = SpotAllocationStrategy.values().first { it.javaValue == javaType }
    }
}
