@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurefleet.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the storage account type for the managed disk. NOTE: UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk.
 */
public enum class StorageAccountTypes(
    public val javaValue: com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes,
) : ConvertibleToJava<com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes> {
    Standard_LRS(com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes.Standard_LRS),
    Premium_LRS(com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes.Premium_LRS),
    StandardSSD_LRS(com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes.StandardSSD_LRS),
    UltraSSD_LRS(com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes.UltraSSD_LRS),
    Premium_ZRS(com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes.Premium_ZRS),
    StandardSSD_ZRS(com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes.StandardSSD_ZRS),
    PremiumV2_LRS(com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes.PremiumV2_LRS),
    ;

    override fun toJava(): com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurefleet.enums.StorageAccountTypes): StorageAccountTypes = StorageAccountTypes.values().first { it.javaValue == javaType }
    }
}
